<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('failed_jobs', function (Blueprint $table) {
            $table->string('uuid')->unique()->after('id');
            $table->longText('payload')->change();
            $table->longText('exception')->change();
        });
    }

    public function down(): void
    {
        Schema::table('failed_jobs', function (Blueprint $table) {
            $table->dropUnique('failed_jobs_uuid_unique');
            $table->dropColumn(['uuid']);
            $table->text('payload')->change();
            $table->text('exception')->change();
        });
    }
};
